(function($){'use strict';

function showNotification(msg, type){
    $('.gmb-ag-copied').remove();
    var bgColor = type === 'error' ? '#dc3545' : '#f88b22';
    $('<div class="gmb-ag-copied" style="background:'+bgColor+'">'+msg+'</div>').appendTo('body');
    setTimeout(function(){$('.gmb-ag-copied').fadeOut(300,function(){$(this).remove()})},3000);
}

// Copy API key
$('#gmb_ag_copy_key').on('click',function(){
    var key=$('#gmb_ag_api_key').val();
    if(navigator.clipboard){
        navigator.clipboard.writeText(key).then(function(){
            showNotification(gmb_ag_admin.strings.copied);
        });
    }else{
        $('#gmb_ag_api_key').select();
        document.execCommand('copy');
        showNotification(gmb_ag_admin.strings.copied);
    }
});

// Regenerate API key
$('#gmb_ag_regenerate_key').on('click',function(){
    if(!confirm(gmb_ag_admin.strings.confirm_regenerate))return;
    var $btn=$(this).prop('disabled',true);
    $.post(gmb_ag_admin.ajax_url,{action:'gmb_ag_regenerate_key',nonce:gmb_ag_admin.nonce},function(r){
        if(r.success){
            $('#gmb_ag_api_key').val(r.data.key);
            showNotification('Cle regeneree');
        }else{
            showNotification(r.data,'error');
        }
        $btn.prop('disabled',false);
    });
});

// Clear logs
$('#gmb_ag_clear_logs').on('click',function(){
    if(!confirm(gmb_ag_admin.strings.confirm_clear_logs))return;
    var $btn=$(this).prop('disabled',true);
    $.post(gmb_ag_admin.ajax_url,{action:'gmb_ag_clear_logs',nonce:gmb_ag_admin.nonce},function(r){
        if(r.success){
            showNotification(r.data.message);
            setTimeout(function(){location.reload()},1000);
        }else{
            showNotification(r.data,'error');
        }
        $btn.prop('disabled',false);
    });
});

// Export logs
$('#gmb_ag_export_logs').on('click',function(){
    var $btn=$(this).prop('disabled',true);
    $.post(gmb_ag_admin.ajax_url,{action:'gmb_ag_export_logs',nonce:gmb_ag_admin.nonce},function(r){
        if(r.success){
            var csv=atob(r.data.csv);
            var blob=new Blob([csv],{type:'text/csv;charset=utf-8;'});
            var link=document.createElement('a');
            link.href=URL.createObjectURL(blob);
            link.download=r.data.filename;
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            showNotification('Export telecharge');
        }else{
            showNotification(r.data,'error');
        }
        $btn.prop('disabled',false);
    });
});

// Activate license
$('#gmb_ag_activate_license').on('click',function(){
    var $btn=$(this).prop('disabled',true);
    var license_key=$('#gmb_ag_license_key_input').val().trim();
    
    if(!license_key){
        showNotification('Entrez une cle de licence','error');
        $btn.prop('disabled',false);
        return;
    }
    
    $btn.text(gmb_ag_admin.strings.activating || 'Activation...');
    
    $.post(gmb_ag_admin.ajax_url,{
        action:'gmb_ag_activate_license',
        nonce:gmb_ag_admin.nonce,
        license_key:license_key
    },function(r){
        if(r.success){
            showNotification('Licence activee avec succes !');
            setTimeout(function(){location.reload()},1500);
        }else{
            showNotification(r.data || 'Echec de l\'activation','error');
            $btn.prop('disabled',false).html('<span class="dashicons dashicons-yes"></span> Activer la licence');
        }
    }).fail(function(){
        showNotification('Erreur de connexion','error');
        $btn.prop('disabled',false).html('<span class="dashicons dashicons-yes"></span> Activer la licence');
    });
});

// Deactivate license
$('#gmb_ag_deactivate_license').on('click',function(){
    if(!confirm('Desactiver la licence sur ce site ?'))return;
    var $btn=$(this).prop('disabled',true);
    
    $.post(gmb_ag_admin.ajax_url,{
        action:'gmb_ag_deactivate_license',
        nonce:gmb_ag_admin.nonce
    },function(r){
        if(r.success){
            showNotification('Licence desactivee');
            setTimeout(function(){location.reload()},1500);
        }else{
            showNotification(r.data || 'Erreur','error');
            $btn.prop('disabled',false);
        }
    });
});

// Check license
$('#gmb_ag_check_license').on('click',function(){
    var $btn=$(this).prop('disabled',true);
    
    $.post(gmb_ag_admin.ajax_url,{
        action:'gmb_ag_check_license',
        nonce:gmb_ag_admin.nonce
    },function(r){
        if(r.success){
            showNotification('Licence valide !');
            setTimeout(function(){location.reload()},1500);
        }else{
            showNotification(r.data.message || 'Licence invalide','error');
            setTimeout(function(){location.reload()},1500);
        }
        $btn.prop('disabled',false);
    });
});

})(jQuery);
